--default_box_indices  = {0, 1, 2, 0, 2, 3}
--default_rect_indices = {0, 1, 1, 2, 2, 3, 3, 0}
local lfs = require('lfs')

modpath = LockOn_Options.script_path.."MFD_MOD/"

dofile(LockOn_Options.common_script_path.."elements_defs.lua")
dofile(LockOn_Options.common_script_path.."tools.lua")

SetCustomScale(0.1 * 1)

IndicationTexturesPath 	= LockOn_Options.script_path.."POSTIT_MOD/"
DEBUG_MATERIAL   		= MakeMaterial(nil,{255,120,0,120})
--NOTEPAD_TEXTURE 		= MakeMaterial(IndicationTexturesPath.."uh01_postit.dds", {255, 255, 255, 255})
NOTEPAD_TEXTURE 		= MakeMaterial(IndicationTexturesPath.."uh01_postit.dds", {5, 5, 5, 255})

--NOTEPAD_OVERLAY 		= MakeMaterial(nil, {255, 255, 255, 100})
NOTEPAD_OVERLAY 		= MakeMaterial(nil, {1, 1, 1, 230})


--TEXT_BLACK_COLOR 	= {30, 30, 30, 255}
TEXT_BLACK_COLOR 	= {36, 148, 102, 255}
POSTIT_FONT 		= MakeFont({used_DXUnicodeFontData = "font_arial_17"},TEXT_BLACK_COLOR)		 

local font_scale					= 1.15
local font_size 					= 0.008						* font_scale
local default_char_height  			= font_size or 0.004		* font_scale
local default_char_width   			= 0.3 * default_char_height	* font_scale
local default_char_vert_spaceing 	= -0.001						

postit_stringdefs 	= 	{default_char_height, default_char_width,0, default_char_vert_spaceing} 




POSTIT_DEFAULT_LEVEL = 15
local np_size 	= 0.4
local x_size    = np_size
local y_size    = np_size * 1.34

local 	pm_notepad     				= CreateElement "ceTexPoly"
		pm_notepad.primitivetype 	= "triangles"
		pm_notepad.name				= "pm_notepad"
		pm_notepad.init_pos			= {0,0,0}
		pm_notepad.material      	= NOTEPAD_TEXTURE
		pm_notepad.vertices			= {	{-x_size, y_size},
											{ x_size, y_size},
											{ x_size,-y_size},
											{-x_size,-y_size}}
		pm_notepad.indices       	= {0, 1, 2, 0, 2, 3} 
		pm_notepad.h_clip_relation	= h_clip_relations.REWRITE_LEVEL
		pm_notepad.level	  		= POSTIT_DEFAULT_LEVEL
		pm_notepad.tex_params		={186/512, 248/512, 0.35 / np_size, 0.35 / np_size}
	Add(pm_notepad)
	


	
-------------------------------------------------------------------------------------------

local 	pm_txt_1           	  	= CreateElement "ceStringPoly"
		pm_txt_1.name           = "pm_txt_1"
		pm_txt_1.material       = POSTIT_FONT
		pm_txt_1.init_pos       = {-(x_size * 0.90),(y_size * 0.95),0}
		pm_txt_1.alignment      = "LeftTop"
		pm_txt_1.stringdefs     = postit_stringdefs
		pm_txt_1.value			= ""
		pm_txt_1.formats        = {"%s","%0.f%%"}  
		pm_txt_1.h_clip_relation= h_clip_relations.REWRITE_LEVEL--h_clip_relations.COMPARE
		pm_txt_1.level	  		= POSTIT_DEFAULT_LEVEL
		pm_txt_1.controllers    = {{"text_using_parameter",0,0}}
		
	Add(pm_txt_1)

local 	y_offset  = -0.01 -- -0.47 * 0
local 	text_dist = 0.09

for i = 2,4 do

	local 	pm_txt_2_name           	= Copy(pm_txt_1)
			pm_txt_2_name.name          = "pm_txt_" .. i .. "_name"
			pm_txt_2_name.value			= ""
			pm_txt_2_name.init_pos      = {-(x_size * 0.90),(y_size * 0.95) + y_offset ,0}
			pm_txt_2_name.element_params= {"PIM_" .. i .. "_NAME"}
		Add(pm_txt_2_name)
		
	local 	pm_txt_2_burst           	= Copy(pm_txt_1)
			pm_txt_2_burst.name         = "pm_txt_" .. i .. "_burst"
			pm_txt_2_burst.value		= ""
			pm_txt_2_burst.alignment    = "LeftTop"
			pm_txt_2_burst.init_pos     = {-(x_size * 0.90),(y_size * 0.95)+ y_offset -text_dist*2 ,0}
			pm_txt_2_burst.element_params= {"PIM_" .. i .. "_BURST"}
		Add(pm_txt_2_burst)	
		
	local 	pm_txt_2_status           		= Copy(pm_txt_1)
			pm_txt_2_status.name        	= "pm_txt_" .. i .. "_status"
			pm_txt_2_status.value			= ""
			pm_txt_2_status.alignment   	= "LeftTop"
			pm_txt_2_status.init_pos    	= {-(x_size * 0.90),(y_size * 0.95)+ y_offset  - text_dist,0}
			pm_txt_2_status.element_params 	= {"PIM_" .. i .. "_STATUS"}
		Add(pm_txt_2_status)	
		
	local 	pm_txt_2_ammo           	= Copy(pm_txt_1)
			pm_txt_2_ammo.name          = "pm_txt_" .. i .. "_ammo"
			pm_txt_2_ammo.value			= ""
			pm_txt_2_ammo.alignment     = "RightTop"
			pm_txt_2_ammo.init_pos      = {(x_size * 0.90),(y_size * 0.95)+ y_offset  - text_dist*2,0}
			pm_txt_2_ammo.element_params= {"PIM_" .. i .. "_AMMO"}
			pm_txt_2_ammo.controllers   = {{"text_using_parameter",0,1}}
		Add(pm_txt_2_ammo)	
	
	y_offset = y_offset -0.35
end	

x_size    = 1.001 * np_size
y_size    = 1.001 * np_size * 1.34

local 	pm_notepad_overlay     				= CreateElement "ceTexPoly"
		pm_notepad_overlay.primitivetype 	= "triangles"
		pm_notepad_overlay.name				= "pm_notepad_overlay"
		pm_notepad_overlay.init_pos			= {0,0,-0.0001}
		pm_notepad_overlay.material      	= NOTEPAD_OVERLAY--NOTEPAD_TEXTURE
		pm_notepad_overlay.vertices			= {	{-x_size, y_size},
											{ x_size, y_size},
											{ x_size,-y_size},
											{-x_size,-y_size}}
		pm_notepad_overlay.indices       	= {0, 1, 2, 0, 2, 3} 
		pm_notepad_overlay.h_clip_relation	= h_clip_relations.REWRITE_LEVEL
		pm_notepad_overlay.level	  		= POSTIT_DEFAULT_LEVEL
		pm_notepad_overlay.controllers      = {{"draw_argument_in_range",459,0.1,1.1}}
	Add(pm_notepad_overlay)